import '../../../core/utils/method.dart';
import '../../../core/utils/url_container.dart';
import '../../model/global/response_model/response_model.dart';
import '../../model/invoice/invoice_items_model.dart';
import '../../services/api_service.dart';

class UpdateInvoiceRepo {
  ApiClient apiClient;
  UpdateInvoiceRepo({required this.apiClient});

  Future<ResponseModel> getData({required String invoiceNum}) async {
    String url = "${UrlContainer.baseUrl}${UrlContainer.invoiceEditUrl}/$invoiceNum";

    ResponseModel responseModel = await apiClient.request(url, Method.getMethod, null, passHeader: true);
    return responseModel;
  }

  Future<ResponseModel> updateInvoice({required String invoiceId, required String invoiceItemName, required String invoiceAmount, required List<InvoiceItemsModel> invoiceItemList}) async {
    String url = "${UrlContainer.baseUrl}${UrlContainer.invoiceUpdateUrl}/$invoiceId";

    Map<String, String> params = {};

    int i = 0;
    for (var invoice in invoiceItemList) {
      String itemName = invoice.itemNameController.text;
      String amount = invoice.amountController.text;

      if (itemName.isNotEmpty && amount.isNotEmpty) {
        i = i + 1;
        params["name[$i]"] = itemName;
        params["amount[$i]"] = amount;
      }
    }

    ResponseModel responseModel = await apiClient.request(url, Method.postMethod, params, passHeader: true);
    return responseModel;
  }

  Future<ResponseModel> sendToEmail(String invoiceId) async {
    String url = "${UrlContainer.baseUrl}${UrlContainer.invoiceSendEmailUrl}$invoiceId";

    ResponseModel responseModel = await apiClient.request(url, Method.getMethod, null, passHeader: true);
    return responseModel;
  }

  Future<ResponseModel> publishInvoice(String invoiceId) async {
    String url = "${UrlContainer.baseUrl}${UrlContainer.invoicePublishUrl}$invoiceId";

    ResponseModel responseModel = await apiClient.request(url, Method.getMethod, null, passHeader: true);
    return responseModel;
  }

  Future<ResponseModel> cancelInvoice(String invoiceId, String cancelReason) async {
    String url = "${UrlContainer.baseUrl}${UrlContainer.invoiceDiscardUrl}$invoiceId";
    Map<String, String> params = {
      "cancel_reason": cancelReason,
    };
    ResponseModel responseModel = await apiClient.request(url, Method.postMethod, params, passHeader: true);
    return responseModel;
  }
}
